import React from 'react'
export default function Hero({title, subtitle, image}){
  return (
    <section className="relative bg-cover bg-center" style={{backgroundImage:`url(${image})`}}>
      <div className="bg-black/40 py-20">
        <div className="container text-white text-center">
          <h1 className="text-3xl md:text-5xl font-bold">{title}</h1>
          <p className="mt-4 max-w-2xl mx-auto">{subtitle}</p>
        </div>
      </div>
    </section>
  )
}