import React from 'react'
import { Link, NavLink } from 'react-router-dom'

export default function Navbar(){
  return (
    <header className="bg-white shadow-sm">
      <div className="container flex items-center justify-between h-16">
        <Link to='/' className="text-xl font-bold text-blue-600">MaverickSolutions</Link>
        <nav className="hidden md:flex space-x-6 text-sm">
          <NavLink to="/" className={({isActive})=> isActive ? 'text-blue-600 font-semibold' : 'text-gray-600'} end>Home</NavLink>
          <NavLink to="/about" className={({isActive})=> isActive ? 'text-blue-600 font-semibold' : 'text-gray-600'}>About</NavLink>
          <NavLink to="/services" className={({isActive})=> isActive ? 'text-blue-600 font-semibold' : 'text-gray-600'}>Services</NavLink>
          <NavLink to="/portfolio" className={({isActive})=> isActive ? 'text-blue-600 font-semibold' : 'text-gray-600'}>Portfolio</NavLink>
          <NavLink to="/contact" className={({isActive})=> isActive ? 'text-blue-600 font-semibold' : 'text-gray-600'}>Contact</NavLink>
        </nav>
        <div className="md:hidden">
          <button id="menu-btn" aria-label="open menu" className="text-gray-700">Menu</button>
        </div>
      </div>
    </header>
  )
}