import React from 'react'
export default function ServiceCard({title,desc,icon}){
  return (
    <div className="bg-white rounded-lg p-6 shadow-sm hover:shadow-md transition">
      <div className="flex items-center space-x-4">
        <div className="w-12 h-12 flex items-center justify-center rounded-md bg-blue-50 text-blue-600">{icon}</div>
        <div>
          <h3 className="font-semibold text-lg">{title}</h3>
          <p className="text-sm text-gray-600 mt-1">{desc}</p>
        </div>
      </div>
    </div>
  )
}