import React from 'react'
import Hero from '../components/Hero'
import team from '../assets/images/team.jpg'
export default function About(){
  return (
    <div>
      <Hero title="About MaverickSolutions" subtitle="A nimble team building digital products and experiences" image={team} />
      <section className="container py-12">
        <h2 className="text-2xl font-bold mb-4">Our Mission</h2>
        <p className="text-gray-700">To empower businesses with sustainable, secure, and beautiful digital solutions.</p>
        <div className="mt-6 grid md:grid-cols-3 gap-6">
          <div className="bg-white p-6 rounded shadow"><h4 className="font-semibold">Quality</h4><p className="text-sm text-gray-600 mt-2">Best-in-class engineering and design.</p></div>
          <div className="bg-white p-6 rounded shadow"><h4 className="font-semibold">Reliability</h4><p className="text-sm text-gray-600 mt-2">Strong ops and monitoring practices.</p></div>
          <div className="bg-white p-6 rounded shadow"><h4 className="font-semibold">Growth</h4><p className="text-sm text-gray-600 mt-2">SEO and marketing that move the needle.</p></div>
        </div>
      </section>
    </div>
  )
}