import React from 'react'
import Hero from '../components/Hero'
import contactImg from '../assets/images/contact.jpg'
export default function Contact(){
  return (
    <div>
      <Hero title="Contact" subtitle="Start your project with MaverickSolutions" image={contactImg} />
      <section className="container py-12 max-w-2xl">
        <form className="bg-white rounded p-6 shadow space-y-4" onSubmit={(e)=>{e.preventDefault(); alert('Demo: message sent')}}>
          <div><label className="block text-sm font-medium">Name</label><input required className="w-full border rounded px-3 py-2" /></div>
          <div><label className="block text-sm font-medium">Email</label><input type="email" required className="w-full border rounded px-3 py-2" /></div>
          <div><label className="block text-sm font-medium">Message</label><textarea required className="w-full border rounded px-3 py-2 h-28"></textarea></div>
          <div className="text-right"><button className="bg-blue-600 text-white px-4 py-2 rounded">Send Message</button></div>
        </form>
      </section>
    </div>
  )
}