import React from 'react'
import Hero from '../components/Hero'
import ServiceCard from '../components/ServiceCard'
import heroImg from '../assets/images/hero.jpg'
import img1 from '../assets/images/service1.jpg'
import img2 from '../assets/images/service2.jpg'

export default function Home(){
  const services = [
    {title:'Web Development', desc:'Full-stack web apps, PWAs, and e-commerce', icon:'</>'},
    {title:'Design & Branding', desc:'UI/UX, visual identity, and product design', icon:'🎨'},
    {title:'SEO & Marketing', desc:'Organic growth, content & paid campaigns', icon:'📈'},
    {title:'Hosting & Ops', desc:'Managed hosting, DevOps and monitoring', icon:'⚙️'},
  ]
  return (
    <div>
      <Hero title="MaverickSolutions — All‑round Web & Digital Services" subtitle="Design · Build · Grow · Host" image={heroImg} />
      <section className="container py-12">
        <h2 className="text-2xl font-bold mb-6">What we do</h2>
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
          {services.map(s=> <ServiceCard key={s.title} title={s.title} desc={s.desc} icon={s.icon} />)}
        </div>
      </section>
      <section className="container py-12">
        <h2 className="text-2xl font-bold mb-6">Featured Work</h2>
        <div className="grid md:grid-cols-2 gap-6">
          <div className="bg-white rounded-lg shadow overflow-hidden"><img src={img1} alt="work 1" className="w-full h-56 object-cover"/><div className="p-4"><h3 className="font-semibold">Project Alpha</h3><p className="text-sm text-gray-600">A modern e-commerce platform.</p></div></div>
          <div className="bg-white rounded-lg shadow overflow-hidden"><img src={img2} alt="work 2" className="w-full h-56 object-cover"/><div className="p-4"><h3 className="font-semibold">Project Beta</h3><p className="text-sm text-gray-600">Branding and marketing suite.</p></div></div>
        </div>
      </section>
    </div>
  )
}