import React from 'react'
import Hero from '../components/Hero'
import p1 from '../assets/images/project1.jpg'
import p2 from '../assets/images/project2.jpg'
import p3 from '../assets/images/project3.jpg'

export default function Portfolio(){
  const projects = [
    {title:'Alpha Commerce', img:p1, desc:'E-commerce platform for lifestyle brand'},
    {title:'City Services', img:p2, desc:'Public sector portal and CRM'},
    {title:'LogiTrack', img:p3, desc:'Logistics dashboard and analytics'}
  ]
  return (
    <div>
      <Hero title="Portfolio" subtitle="Selected projects & case studies" image={p1} />
      <section className="container py-12 grid md:grid-cols-3 gap-6">
        {projects.map((p,i)=> (
          <div key={i} className="bg-white rounded-lg shadow overflow-hidden">
            <img src={p.img} alt={p.title} className="w-full h-48 object-cover"/>
            <div className="p-4"><h4 className="font-semibold">{p.title}</h4><p className="text-sm text-gray-600 mt-2">{p.desc}</p></div>
          </div>
        ))}
      </section>
    </div>
  )
}