import React from 'react'
import Hero from '../components/Hero'
import ServiceCard from '../components/ServiceCard'
import svc from '../assets/images/service1.jpg'

export default function Services(){
  const list = [
    {title:'Custom Web Apps', desc:'React, Next.js, APIs, and real-time systems'},
    {title:'Ecommerce', desc:'Shopify, custom carts, payments and fulfillment'},
    {title:'Design & Branding', desc:'UI/UX, identity systems, and design sprints'},
    {title:'SEO & Marketing', desc:'Technical SEO, content strategy, and ads'},
    {title:'Hosting & DevOps', desc:'Managed servers, CDN, backups and monitoring'},
  ]
  return (
    <div>
      <Hero title="Services" subtitle="End-to-end digital services" image={svc} />
      <section className="container py-12">
        <div className="grid md:grid-cols-2 gap-6">
          {list.map(s=> <div key={s.title} className="bg-white rounded p-6 shadow"><h3 className="font-semibold">{s.title}</h3><p className="text-sm text-gray-600 mt-2">{s.desc}</p></div>)}
        </div>
      </section>
    </div>
  )
}